/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.solarcooker.platform;

import de.cech12.solarcooker.platform.services.IConfigHelper;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import me.shedaniel.autoconfig.serializer.Toml4jConfigSerializer;
import net.minecraft.class_1874;
import net.minecraft.class_3956;
import net.minecraft.class_7923;

@Config(name="solarcooker")
public class FabricConfigHelper
implements ConfigData,
IConfigHelper {
    @ConfigEntry.Gui.Tooltip(count=4)
    public boolean VANILLA_RECIPES_ENABLED = true;
    @ConfigEntry.Gui.Tooltip(count=4)
    public String VANILLA_RECIPE_TYPE = class_7923.field_41188.method_10221((Object)VANILLA_RECIPE_TYPE_DEFAULT).method_12832();
    @ConfigEntry.Gui.Tooltip(count=6)
    public int COOK_TIME_FACTOR = 400;
    @ConfigEntry.Gui.Tooltip(count=6)
    public int MAX_REFLECTOR_TIME_FACTOR = 50;
    @ConfigEntry.Gui.Tooltip(count=5)
    public String RECIPE_BLOCKED_LIST = "";

    @Override
    public void init() {
        AutoConfig.register(FabricConfigHelper.class, Toml4jConfigSerializer::new);
    }

    private FabricConfigHelper getConfig() {
        return (FabricConfigHelper)AutoConfig.getConfigHolder(FabricConfigHelper.class).getConfig();
    }

    @Override
    public boolean areVanillaRecipesEnabled() {
        return this.getConfig().VANILLA_RECIPES_ENABLED;
    }

    @Override
    public class_3956<? extends class_1874> getRecipeType() {
        return switch (this.getConfig().VANILLA_RECIPE_TYPE) {
            case "smoking" -> class_3956.field_17548;
            case "smelting" -> class_3956.field_17546;
            case "campfire_cooking" -> class_3956.field_17549;
            case "blasting" -> class_3956.field_17547;
            default -> VANILLA_RECIPE_TYPE_DEFAULT;
        };
    }

    @Override
    public double getCookTimeFactor() {
        return Math.clamp((double)this.getConfig().COOK_TIME_FACTOR / 100.0, 0.0, 100.0);
    }

    @Override
    public double getMaxReflectorTimeFactor() {
        return Math.clamp((double)this.getConfig().MAX_REFLECTOR_TIME_FACTOR / 100.0, 0.0, 1.0);
    }

    @Override
    public String getRecipeBlockedList() {
        return this.getConfig().RECIPE_BLOCKED_LIST;
    }
}

